<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2 { margin: 0 0 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f6f6f6; }
    </style>
</head>
<body>
    <h2>Patients Export</h2>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Lab</th>
                <th>Email</th>
                <th>Phone</th>
                <th>DOB</th>
                <th>Gender</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($patient->id); ?></td>
                    <td><?php echo e($patient->full_name); ?></td>
                    <td><?php echo e(optional($patient->lab)->name); ?> <?php echo e(optional($patient->lab)->branch_name); ?></td>
                    <td><?php echo e($patient->email); ?></td>
                    <td><?php echo e($patient->phone); ?></td>
                    <td><?php echo e(optional($patient->dob)->format('Y-m-d')); ?></td>
                    <td><?php echo e($patient->gender); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\frontdesk\patients\export-pdf.blade.php ENDPATH**/ ?>