<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex items-center justify-between gap-3">
            <h2 class="text-xl font-semibold text-slate-800"><?php echo e($patient->full_name); ?></h2>
            <div class="flex items-center gap-2">
                <a href="<?php echo e(route('frontdesk.patients.history', $patient)); ?>" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">History</a>
                <a href="<?php echo e(route('frontdesk.patients.orders.create', $patient)); ?>" class="rounded-lg bg-emerald-600 px-4 py-2 text-sm font-semibold text-white hover:bg-emerald-700">New order</a>
                <a href="<?php echo e(route('frontdesk.patients.edit', $patient)); ?>" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Edit</a>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <div class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
                <div class="grid gap-4 md:grid-cols-4 text-sm">
                    <div><p class="text-slate-500">Lab</p><p class="font-medium"><?php echo e(optional($patient->lab)->name); ?> <?php echo e(optional($patient->lab)->branch_name); ?></p></div>
                    <div><p class="text-slate-500">Email</p><p class="font-medium"><?php echo e($patient->email ?: '-'); ?></p></div>
                    <div><p class="text-slate-500">Phone</p><p class="font-medium"><?php echo e($patient->phone ?: '-'); ?></p></div>
                    <div><p class="text-slate-500">Gender</p><p class="font-medium"><?php echo e(ucfirst($patient->gender ?: '-')); ?></p></div>
                    <div><p class="text-slate-500">DOB</p><p class="font-medium"><?php echo e(optional($patient->dob)->format('Y-m-d') ?: '-'); ?></p></div>
                </div>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="border-b border-slate-200 px-4 py-3 flex items-center justify-between">
                    <h3 class="font-semibold text-slate-800">Orders</h3>
                    <form method="POST" action="<?php echo e(route('frontdesk.patients.destroy', $patient)); ?>" onsubmit="return confirm('Delete this patient? This will remove linked orders.');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="rounded-lg border border-red-200 bg-red-50 px-3 py-1 text-xs font-semibold text-red-700">Delete patient</button>
                    </form>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Code</th>
                                <th class="px-4 py-2 text-left">Lab</th>
                                <th class="px-4 py-2 text-left">Status</th>
                                <th class="px-4 py-2 text-left">Total</th>
                                <th class="px-4 py-2 text-right">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2"><?php echo e($order->order_code); ?></td>
                                    <td class="px-4 py-2"><?php echo e(optional($order->lab)->name); ?> <?php echo e(optional($order->lab)->branch_name); ?></td>
                                    <td class="px-4 py-2 uppercase text-xs"><?php echo e($order->status); ?></td>
                                    <td class="px-4 py-2"><?php echo e(number_format((float) $order->total, 2)); ?></td>
                                    <td class="px-4 py-2 text-right"><a class="text-sky-700 hover:text-sky-800 text-xs font-semibold" href="<?php echo e(route('frontdesk.orders.show', $order)); ?>">Open</a></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="px-4 py-5 text-slate-500" colspan="5">No orders found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3"><?php echo e($orders->links()); ?></div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\frontdesk\patients\show.blade.php ENDPATH**/ ?>