<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Patient Portal - <?php echo e($brandName ?? config('app.name', 'Lab Result Portal')); ?></title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="bg-slate-100 text-slate-900 antialiased">
    <main class="mx-auto max-w-5xl px-4 py-8 sm:px-6 lg:px-8">
        <div class="mb-6 flex flex-wrap items-center justify-between gap-3 rounded-2xl border border-slate-200 bg-white p-5 shadow-sm">
            <div>
                <p class="text-sm text-slate-600">Signed in as</p>
                <h1 class="text-2xl font-semibold"><?php echo e($patient->full_name); ?></h1>
                <p class="text-sm text-slate-600"><?php echo e($patient->email ?: 'No email'); ?> | <?php echo e($patient->phone ?: 'No phone'); ?></p>
            </div>
            <div class="flex items-center gap-2">
                <a href="<?php echo e(route('patient.transactions.receipt')); ?>" class="inline-flex items-center justify-center rounded-lg border border-slate-300 px-4 py-2 text-sm font-semibold text-slate-700 hover:bg-slate-50">
                    Download Receipt
                </a>
                <form method="POST" action="<?php echo e(route('patient.logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php if (isset($component)) { $__componentOriginald411d1792bd6cc877d687758b753742c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald411d1792bd6cc877d687758b753742c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.primary-button','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('primary-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>Logout <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald411d1792bd6cc877d687758b753742c)): ?>
<?php $attributes = $__attributesOriginald411d1792bd6cc877d687758b753742c; ?>
<?php unset($__attributesOriginald411d1792bd6cc877d687758b753742c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald411d1792bd6cc877d687758b753742c)): ?>
<?php $component = $__componentOriginald411d1792bd6cc877d687758b753742c; ?>
<?php unset($__componentOriginald411d1792bd6cc877d687758b753742c); ?>
<?php endif; ?>
                </form>
            </div>
        </div>

        <section class="rounded-2xl border border-slate-200 bg-white p-5 shadow-sm">
            <h2 class="mb-4 text-lg font-semibold">My Lab Orders</h2>

            <?php if($orders->isEmpty()): ?>
                <p class="text-sm text-slate-600">No lab orders found yet.</p>
            <?php else: ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <article class="rounded-xl border border-slate-200 p-4">
                            <div class="flex flex-wrap items-start justify-between gap-2">
                                <div>
                                    <p class="text-sm text-slate-600">Order</p>
                                    <p class="font-semibold"><?php echo e($order->order_code); ?></p>
                                    <p class="text-xs text-slate-500">
                                        <?php echo e(optional($order->lab)->name); ?><?php echo e(optional($order->lab)->branch_name ? ' - '.optional($order->lab)->branch_name : ''); ?>

                                    </p>
                                </div>
                                <span class="rounded-full bg-sky-100 px-3 py-1 text-xs font-semibold uppercase text-sky-700"><?php echo e($order->status); ?></span>
                            </div>

                            <div class="mt-3 text-sm text-slate-700">
                                <p>Total: <?php echo e(number_format((float) $order->total, 2)); ?></p>
                                <p>Paid: <?php echo e(number_format((float) $order->paid, 2)); ?> | Balance: <?php echo e(number_format((float) $order->balance, 2)); ?></p>
                            </div>

                            <div class="mt-3 border-t border-slate-200 pt-3">
                                <p class="text-xs font-semibold uppercase text-slate-500">Results</p>
                                <?php $__empty_1 = true; $__currentLoopData = $order->results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="mt-1 text-sm">
                                        <a href="<?php echo e(route('patient.results.download', [$order, $result])); ?>" class="text-sky-700 hover:text-sky-800">
                                            Download version <?php echo e($result->version); ?>

                                        </a>
                                        <span class="text-slate-500">(<?php echo e(optional($result->created_at)->format('Y-m-d H:i')); ?>)</span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <p class="text-sm text-slate-500 mt-1">No result uploaded yet.</p>
                                <?php endif; ?>
                            </div>
                        </article>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </section>
    </main>
</body>
</html>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\patient\portal.blade.php ENDPATH**/ ?>