<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="text-xl font-semibold text-slate-800">Orders</h2>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="rounded-lg border border-emerald-200 bg-emerald-50 px-4 py-3 text-sm text-emerald-700"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                <form class="grid gap-3 md:grid-cols-5" method="GET" action="<?php echo e(route('frontdesk.orders.index')); ?>">
                    <input type="text" name="q" value="<?php echo e(request('q')); ?>" placeholder="Search by code or patient" class="md:col-span-2 rounded-lg border-slate-300">
                    <select name="status" class="rounded-lg border-slate-300">
                        <option value="">All statuses</option>
                        <?php $__currentLoopData = ['draft','pending','paid','ready','delivered','cancelled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($status); ?>" <?php if(request('status') === $status): echo 'selected'; endif; ?>><?php echo e(ucfirst($status)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <button type="submit" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Filter</button>
                    <div class="flex items-center gap-2 md:justify-end">
                        <a href="<?php echo e(route('frontdesk.orders.export.csv', request()->query())); ?>" class="rounded-lg border border-slate-300 px-3 py-2 text-xs font-semibold">CSV</a>
                        <a href="<?php echo e(route('frontdesk.orders.export.pdf', request()->query())); ?>" class="rounded-lg border border-slate-300 px-3 py-2 text-xs font-semibold">PDF</a>
                        <a href="<?php echo e(route('frontdesk.orders.print', request()->query())); ?>" target="_blank" class="rounded-lg border border-slate-300 px-3 py-2 text-xs font-semibold">Print</a>
                    </div>
                </form>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Code</th>
                                <th class="px-4 py-2 text-left">Patient</th>
                                <th class="px-4 py-2 text-left">Lab</th>
                                <th class="px-4 py-2 text-left">Status</th>
                                <th class="px-4 py-2 text-left">Total</th>
                                <th class="px-4 py-2 text-left">Balance</th>
                                <th class="px-4 py-2 text-right">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2 font-medium"><?php echo e($order->order_code); ?></td>
                                    <td class="px-4 py-2"><?php echo e($order->patient->full_name ?? '-'); ?></td>
                                    <td class="px-4 py-2"><?php echo e(optional($order->lab)->name); ?> <?php echo e(optional($order->lab)->branch_name); ?></td>
                                    <td class="px-4 py-2 uppercase text-xs"><?php echo e($order->status); ?></td>
                                    <td class="px-4 py-2"><?php echo e(number_format((float) $order->total, 2)); ?></td>
                                    <td class="px-4 py-2"><?php echo e(number_format((float) $order->balance, 2)); ?></td>
                                    <td class="px-4 py-2 text-right">
                                        <a href="<?php echo e(route('frontdesk.orders.show', $order)); ?>" class="text-sky-700 hover:text-sky-800 text-xs font-semibold">Open</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="px-4 py-6 text-center text-slate-500">No orders found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3"><?php echo e($orders->links()); ?></div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\frontdesk\orders\index.blade.php ENDPATH**/ ?>