<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e($brandName ?? config('app.name', 'Lab Result Portal')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=outfit:500,600,700|manrope:400,500,600,700&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="antialiased text-slate-900 font-['Manrope'] bg-slate-100">
        <div class="min-h-screen relative overflow-hidden">
            <div class="pointer-events-none absolute -top-24 -left-12 h-72 w-72 rounded-full bg-emerald-200/70 blur-3xl"></div>
            <div class="pointer-events-none absolute top-16 -right-16 h-72 w-72 rounded-full bg-sky-200/80 blur-3xl"></div>
            <div class="pointer-events-none absolute -bottom-24 left-1/4 h-72 w-72 rounded-full bg-amber-200/80 blur-3xl"></div>

            <div class="relative min-h-screen grid place-items-center px-4 py-8 sm:px-6 lg:px-8">
                <div class="w-full max-w-5xl rounded-3xl border border-white/70 bg-white/70 shadow-2xl backdrop-blur-sm overflow-hidden">
                    <div class="grid lg:grid-cols-2">
                        <section class="hidden lg:flex flex-col justify-between bg-gradient-to-br from-emerald-600 via-teal-600 to-sky-700 p-10 text-white">
                            <div>
                                <a href="/" class="inline-flex items-center gap-3">
                                    <span class="rounded-xl bg-white/20 p-2">
                                        <?php if (isset($component)) { $__componentOriginal8892e718f3d0d7a916180885c6f012e7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8892e718f3d0d7a916180885c6f012e7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.application-logo','data' => ['class' => 'h-8 w-8 fill-current text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('application-logo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'h-8 w-8 fill-current text-white']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8892e718f3d0d7a916180885c6f012e7)): ?>
<?php $attributes = $__attributesOriginal8892e718f3d0d7a916180885c6f012e7; ?>
<?php unset($__attributesOriginal8892e718f3d0d7a916180885c6f012e7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8892e718f3d0d7a916180885c6f012e7)): ?>
<?php $component = $__componentOriginal8892e718f3d0d7a916180885c6f012e7; ?>
<?php unset($__componentOriginal8892e718f3d0d7a916180885c6f012e7); ?>
<?php endif; ?>
                                    </span>
                                    <span class="text-lg font-semibold tracking-tight font-['Outfit']">
                                        <?php echo e($brandName ?? config('app.name', 'Lab Result Portal')); ?>

                                    </span>
                                </a>
                                <h2 class="mt-10 text-4xl leading-tight font-semibold font-['Outfit']">
                                    Secure access to laboratory workflows.
                                </h2>
                                <p class="mt-4 text-white/90 text-sm leading-6 max-w-md">
                                    Sign in to manage patient records, process test orders, and publish reports with controlled access.
                                </p>
                            </div>
                            <div class="grid gap-3 text-sm">
                                <div class="rounded-xl border border-white/30 bg-white/10 px-4 py-3">Real-time order status and report tracking</div>
                                <div class="rounded-xl border border-white/30 bg-white/10 px-4 py-3">Role-based access for staff and management</div>
                                <div class="rounded-xl border border-white/30 bg-white/10 px-4 py-3">Centralized patient and billing records</div>
                            </div>
                        </section>

                        <section class="bg-white/90 p-6 sm:p-10">
                            <div class="mb-8 flex items-center justify-between lg:hidden">
                                <a href="/" class="inline-flex items-center gap-2">
                                    <?php if (isset($component)) { $__componentOriginal8892e718f3d0d7a916180885c6f012e7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8892e718f3d0d7a916180885c6f012e7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.application-logo','data' => ['class' => 'h-8 w-8 fill-current text-emerald-600']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('application-logo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'h-8 w-8 fill-current text-emerald-600']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8892e718f3d0d7a916180885c6f012e7)): ?>
<?php $attributes = $__attributesOriginal8892e718f3d0d7a916180885c6f012e7; ?>
<?php unset($__attributesOriginal8892e718f3d0d7a916180885c6f012e7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8892e718f3d0d7a916180885c6f012e7)): ?>
<?php $component = $__componentOriginal8892e718f3d0d7a916180885c6f012e7; ?>
<?php unset($__componentOriginal8892e718f3d0d7a916180885c6f012e7); ?>
<?php endif; ?>
                                    <span class="text-base font-semibold tracking-tight font-['Outfit']">
                                        <?php echo e($brandName ?? config('app.name', 'Lab Result Portal')); ?>

                                    </span>
                                </a>
                            </div>
                            <?php if (isset($component)) { $__componentOriginalb24df6adf99a77ed35057e476f61e153 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb24df6adf99a77ed35057e476f61e153 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.validation-errors','data' => ['class' => 'mb-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('validation-errors'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mb-4']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb24df6adf99a77ed35057e476f61e153)): ?>
<?php $attributes = $__attributesOriginalb24df6adf99a77ed35057e476f61e153; ?>
<?php unset($__attributesOriginalb24df6adf99a77ed35057e476f61e153); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb24df6adf99a77ed35057e476f61e153)): ?>
<?php $component = $__componentOriginalb24df6adf99a77ed35057e476f61e153; ?>
<?php unset($__componentOriginalb24df6adf99a77ed35057e476f61e153); ?>
<?php endif; ?>
                            <?php echo e($slot); ?>

                        </section>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\layouts\guest.blade.php ENDPATH**/ ?>