<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['disabled' => false]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['disabled' => false]); ?>
<?php foreach (array_filter((['disabled' => false]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div x-data="{ show: false }" class="relative">
    <input
        <?php echo e($disabled ? 'disabled' : ''); ?>

        :type="show ? 'text' : 'password'"
        <?php echo $attributes->merge(['class' => 'border-slate-300 bg-white text-slate-900 placeholder:text-slate-400 focus:border-sky-500 focus:ring-sky-500 rounded-lg shadow-sm pr-11']); ?>

    >

    <button
        type="button"
        @click="show = !show"
        class="absolute inset-y-0 right-0 inline-flex items-center justify-center px-3 text-slate-500 hover:text-slate-700 focus:outline-none"
        :aria-label="show ? 'Hide password' : 'Show password'"
    >
        <svg x-show="!show" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
            <path d="M10 3C5 3 1.73 7.11.46 9.06a1.7 1.7 0 000 1.88C1.73 12.89 5 17 10 17s8.27-4.11 9.54-6.06a1.7 1.7 0 000-1.88C18.27 7.11 15 3 10 3zm0 11a4 4 0 110-8 4 4 0 010 8z"/>
            <path d="M10 8a2 2 0 100 4 2 2 0 000-4z"/>
        </svg>
        <svg x-show="show" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
            <path d="M3.28 2.22a.75.75 0 10-1.06 1.06l14.5 14.5a.75.75 0 001.06-1.06l-2.14-2.14c1.72-1.14 2.98-2.67 3.9-4.08a1.7 1.7 0 000-1.88C18.27 7.11 15 3 10 3c-1.74 0-3.31.5-4.7 1.24L3.28 2.22zM7.24 6.18A4 4 0 0113.82 12.76L7.24 6.18z"/>
            <path d="M6.18 7.24l6.58 6.58A4 4 0 016.18 7.24zM2.67 6.05A22.8 22.8 0 00.46 9.06a1.7 1.7 0 000 1.88C1.73 12.89 5 17 10 17c.96 0 1.86-.15 2.7-.4l-1.68-1.68a4 4 0 01-5.62-5.62L2.67 6.05z"/>
        </svg>
    </button>
</div>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\components\password-input.blade.php ENDPATH**/ ?>