<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($brandName ?? config('app.name', 'Lab Result Portal')); ?></title>
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=outfit:400,500,600,700,800|manrope:400,500,600,700&display=swap" rel="stylesheet" />
    <style>
        :root {
            --shell: #d8dde4;
            --panel: #f7f8fa;
            --hero: #edf2f7;
            --ink: #1b2028;
            --muted: #555f6b;
            --accent: #f05372;
            --line: #20242b;
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            background: var(--shell);
            font-family: Manrope, sans-serif;
            color: var(--ink);
            min-height: 100vh;
            padding: 20px;
        }

        .frame {
            width: min(1320px, 100%);
            min-height: calc(100vh - 40px);
            margin: 0 auto;
            border: 3px solid var(--line);
            border-radius: 36px;
            background: var(--panel);
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }

        .top {
            background: #fff;
            border-bottom: 1px solid #eceff4;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            padding: 22px 34px;
        }

        .brand {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            font-family: Outfit, sans-serif;
            font-weight: 800;
            font-size: 23px;
        }

        .logo {
            width: 34px;
            height: 34px;
            border-radius: 9px;
            overflow: hidden;
            display: grid;
            place-items: center;
            background: #edf2f7;
            border: 1px solid #e0e5ed;
        }

        .logo img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            background: #fff;
        }

        .nav {
            display: flex;
            align-items: center;
            gap: 28px;
            font-family: Outfit, sans-serif;
            font-weight: 500;
            font-size: 28px;
        }

        .nav a {
            text-decoration: none;
            color: #252b35;
            font-size: 32px;
        }

        .hero {
            background: var(--hero);
            flex: 1;
            display: grid;
            grid-template-columns: 1fr 1.15fr;
            align-items: center;
            padding: 48px 52px;
            gap: 24px;
        }

        .copy h1 {
            font-family: Outfit, sans-serif;
            font-weight: 800;
            font-size: clamp(42px, 7vw, 90px);
            line-height: 0.92;
            margin: 0;
        }

        .copy p {
            margin: 24px 0 0;
            color: var(--muted);
            font-size: clamp(18px, 2.2vw, 37px);
            max-width: 520px;
            line-height: 1.3;
        }

        .cta {
            margin-top: 36px;
            display: flex;
            gap: 14px;
            flex-wrap: wrap;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-height: 52px;
            padding: 0 24px;
            border-radius: 999px;
            text-decoration: none;
            font-size: 18px;
            font-weight: 700;
            border: 1px solid transparent;
        }

        .btn-primary {
            background: var(--accent);
            color: #fff;
        }

        .btn-secondary {
            background: transparent;
            color: #2b3340;
            border-color: #cfd6df;
        }

        .art {
            width: 100%;
            max-width: 760px;
            justify-self: end;
        }

        .art img {
            display: block;
            width: 100%;
            height: auto;
        }

        .contact {
            padding: 24px 52px 40px;
            background: #fff;
            border-top: 1px solid #e8ecf2;
        }

        @media (max-width: 1100px) {
            .top { padding: 16px 20px; }
            .hero { padding: 28px 24px; grid-template-columns: 1fr; }
            .contact { padding: 22px 24px 30px; }
            .art { justify-self: center; max-width: 560px; }
            .copy p { max-width: 100%; }
            .nav { gap: 14px; }
            .nav a { font-size: 18px; }
        }

        @media (max-width: 640px) {
            body { padding: 10px; }
            .frame {
                border-radius: 20px;
                min-height: calc(100vh - 20px);
            }
            .top {
                flex-wrap: wrap;
                justify-content: center;
            }
            .brand {
                width: 100%;
                justify-content: center;
            }
            .nav {
                width: 100%;
                justify-content: center;
                flex-wrap: wrap;
            }
            .contact { padding: 20px 16px 26px; }
            .copy h1 { line-height: 1; }
            .btn { width: 100%; }
        }
    </style>
</head>
<body>
    <?php
        $heroTitle = $frontendSettings['hero_title'] ?? 'Science Laboratory';
        $heroSubtitle = $frontendSettings['hero_subtitle'] ?? '';
        $contactTitle = $frontendSettings['contact_title'] ?? 'Contact Us';
        $contactDescription = $frontendSettings['contact_description'] ?? '';
        $contactEmail = $frontendSettings['contact_email'] ?? '';
        $contactPhone = $frontendSettings['contact_phone'] ?? '';
        $contactAddress = $frontendSettings['contact_address'] ?? '';
        $whatsappNumber = $frontendSettings['whatsapp_number'] ?? '';
        $whatsAppDigits = preg_replace('/\D+/', '', $whatsappNumber);
        $whatsAppUrl = $whatsAppDigits ? 'https://wa.me/'.$whatsAppDigits : '';
        $socialLinks = [
            'Facebook' => $frontendSettings['facebook_url'] ?? '',
            'Instagram' => $frontendSettings['instagram_url'] ?? '',
            'X' => $frontendSettings['x_url'] ?? '',
            'LinkedIn' => $frontendSettings['linkedin_url'] ?? '',
        ];
    ?>
    <main class="frame">
        <header class="top">
            <div class="brand">
                <span class="logo">
                    <?php if(!empty($brandLogoUrl)): ?>
                        <img src="<?php echo e($brandLogoUrl); ?>" alt="<?php echo e($brandName ?? config('app.name', 'Lab Result Portal')); ?>">
                    <?php else: ?>
                        <span>+</span>
                    <?php endif; ?>
                </span>
                <span><?php echo e($brandName ?? config('app.name', 'Lab Result Portal')); ?></span>
            </div>

            <nav class="nav">
                <a href="<?php echo e(route('documentation')); ?>">Documentation</a>
                <?php if(Route::has('login')): ?>
                    <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(url('/dashboard')); ?>">Dashboard</a>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>">Staff Login</a>
                        <a href="<?php echo e(route('patient.login')); ?>">Patient OTP Login</a>
                    <?php endif; ?>
                <?php endif; ?>
            </nav>
        </header>

        <section class="hero">
            <article class="copy">
                <h1><?php echo nl2br(e($heroTitle)); ?></h1>
                <p><?php echo e($heroSubtitle); ?></p>
                <div class="cta">
                    <?php if(Route::has('login')): ?>
                        <?php if(auth()->guard()->check()): ?>
                            <a class="btn btn-primary" href="<?php echo e(url('/dashboard')); ?>">Open Dashboard</a>
                        <?php else: ?>
                            <a class="btn btn-primary" href="<?php echo e(route('patient.login')); ?>">More Info</a>
                            <a class="btn btn-secondary" href="<?php echo e(route('login')); ?>">Staff Sign In</a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </article>

            <aside class="art" aria-hidden="true">
                <img src="<?php echo e(asset('images/landing-lab-hero.svg')); ?>" alt="Lab instruments illustration">
            </aside>
        </section>

        <section class="contact">
            <h2 style="margin:0; font-family: Outfit, sans-serif; font-size: 30px;"><?php echo e($contactTitle); ?></h2>
            <?php if($contactDescription): ?>
                <p style="margin:8px 0 0; color:#546170; max-width:780px;"><?php echo e($contactDescription); ?></p>
            <?php endif; ?>

            <div style="display:grid; gap:14px; grid-template-columns:repeat(auto-fit, minmax(220px, 1fr)); margin-top:18px;">
                <?php if($contactEmail): ?>
                    <a href="mailto:<?php echo e($contactEmail); ?>" style="text-decoration:none; color:#1b2028; border:1px solid #dce3ec; border-radius:12px; padding:12px 14px; background:#f9fbff;">
                        <strong style="display:block; font-family: Outfit, sans-serif;">Email</strong>
                        <span><?php echo e($contactEmail); ?></span>
                    </a>
                <?php endif; ?>

                <?php if($contactPhone): ?>
                    <a href="tel:<?php echo e($contactPhone); ?>" style="text-decoration:none; color:#1b2028; border:1px solid #dce3ec; border-radius:12px; padding:12px 14px; background:#f9fbff;">
                        <strong style="display:block; font-family: Outfit, sans-serif;">Phone</strong>
                        <span><?php echo e($contactPhone); ?></span>
                    </a>
                <?php endif; ?>

                <?php if($contactAddress): ?>
                    <div style="color:#1b2028; border:1px solid #dce3ec; border-radius:12px; padding:12px 14px; background:#f9fbff;">
                        <strong style="display:block; font-family: Outfit, sans-serif;">Address</strong>
                        <span><?php echo e($contactAddress); ?></span>
                    </div>
                <?php endif; ?>

                <?php if($whatsAppUrl): ?>
                    <a href="<?php echo e($whatsAppUrl); ?>" target="_blank" rel="noopener noreferrer" style="text-decoration:none; color:#0f5132; border:1px solid #c5ecd8; border-radius:12px; padding:12px 14px; background:#eafaf2;">
                        <strong style="display:block; font-family: Outfit, sans-serif;">Official WhatsApp Business</strong>
                        <span><?php echo e($whatsappNumber); ?></span>
                    </a>
                <?php endif; ?>
            </div>

            <?php if(collect($socialLinks)->filter()->isNotEmpty()): ?>
                <div style="margin-top:16px; display:flex; flex-wrap:wrap; gap:10px;">
                    <?php $__currentLoopData = $socialLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($url): ?>
                            <a href="<?php echo e($url); ?>" target="_blank" rel="noopener noreferrer" style="text-decoration:none; color:#1d2733; border:1px solid #d8dfe8; background:#f7f9fc; border-radius:999px; padding:8px 12px; font-weight:600;">
                                <?php echo e($label); ?>

                            </a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </section>
    </main>
</body>
</html>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\welcome.blade.php ENDPATH**/ ?>