<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 11px; }
        h2 { margin: 0 0 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f6f6f6; }
    </style>
</head>
<body>
    <h2>Orders Export</h2>
    <table>
        <thead>
            <tr>
                <th>Code</th>
                <th>Lab</th>
                <th>Patient</th>
                <th>Status</th>
                <th>Total</th>
                <th>Paid</th>
                <th>Balance</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($order->order_code); ?></td>
                    <td><?php echo e(optional($order->lab)->name); ?> <?php echo e(optional($order->lab)->branch_name); ?></td>
                    <td><?php echo e(optional($order->patient)->full_name); ?></td>
                    <td><?php echo e(strtoupper($order->status)); ?></td>
                    <td><?php echo e(number_format((float) $order->total, 2)); ?></td>
                    <td><?php echo e(number_format((float) $order->paid, 2)); ?></td>
                    <td><?php echo e(number_format((float) $order->balance, 2)); ?></td>
                    <td><?php echo e(optional($order->created_at)->format('Y-m-d H:i')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\frontdesk\orders\export-pdf.blade.php ENDPATH**/ ?>