<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="text-xl font-semibold text-slate-800">Patient OTP Log</h2>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="mx-auto max-w-7xl space-y-4 sm:px-6 lg:px-8">
            <div class="rounded-xl border border-amber-200 bg-amber-50 px-4 py-3 text-sm text-amber-800">
                Use this log only for delivery fallback when patient did not receive OTP. OTPs are time-limited and should be shared only after patient identity confirmation.
            </div>

            <div class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                <form method="GET" action="<?php echo e(route('frontdesk.otps.index')); ?>" class="grid gap-3 md:grid-cols-4">
                    <input type="text" name="q" value="<?php echo e(request('q')); ?>" placeholder="Search patient name/email/phone/identifier" class="md:col-span-2 rounded-lg border-slate-300">
                    <button type="submit" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700">Filter</button>
                    <a href="<?php echo e(route('frontdesk.otps.index')); ?>" class="rounded-lg border border-slate-300 px-4 py-2 text-sm font-medium text-slate-700 text-center">Reset</a>
                </form>
            </div>

            <div class="rounded-xl border border-slate-200 bg-white shadow-sm overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-slate-50 text-slate-600">
                            <tr>
                                <th class="px-4 py-2 text-left">Patient</th>
                                <th class="px-4 py-2 text-left">Channels</th>
                                <th class="px-4 py-2 text-left">OTP</th>
                                <th class="px-4 py-2 text-left">Status</th>
                                <th class="px-4 py-2 text-left">Attempts</th>
                                <th class="px-4 py-2 text-left">Sent</th>
                                <th class="px-4 py-2 text-left">Expires</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $otps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $status = 'active';
                                    if ($otp->consumed_at) {
                                        $status = 'used';
                                    } elseif ($otp->expires_at && $otp->expires_at->isPast()) {
                                        $status = 'expired';
                                    } elseif ($otp->locked_until && $otp->locked_until->isFuture()) {
                                        $status = 'locked';
                                    }
                                ?>
                                <tr class="border-t border-slate-100">
                                    <td class="px-4 py-2">
                                        <div class="font-medium text-slate-800"><?php echo e($otp->patient?->full_name ?: 'Unknown patient'); ?></div>
                                        <div class="text-xs text-slate-500"><?php echo e($otp->patient?->email ?: '-'); ?> | <?php echo e($otp->patient?->phone ?: '-'); ?></div>
                                    </td>
                                    <td class="px-4 py-2 uppercase text-xs"><?php echo e($otp->channel); ?></td>
                                    <td class="px-4 py-2">
                                        <span class="inline-flex rounded-md bg-slate-900 px-2 py-1 font-mono text-xs font-semibold text-white"><?php echo e($otp->plain_code ?: 'n/a'); ?></span>
                                    </td>
                                    <td class="px-4 py-2">
                                        <span class="inline-flex rounded-full px-2 py-1 text-xs font-semibold
                                            <?php if($status === 'active'): ?> bg-emerald-100 text-emerald-700 <?php endif; ?>
                                            <?php if($status === 'used'): ?> bg-sky-100 text-sky-700 <?php endif; ?>
                                            <?php if($status === 'expired'): ?> bg-slate-200 text-slate-700 <?php endif; ?>
                                            <?php if($status === 'locked'): ?> bg-red-100 text-red-700 <?php endif; ?>
                                        "><?php echo e(strtoupper($status)); ?></span>
                                    </td>
                                    <td class="px-4 py-2"><?php echo e($otp->attempts); ?></td>
                                    <td class="px-4 py-2"><?php echo e(optional($otp->created_at)->format('Y-m-d H:i:s')); ?></td>
                                    <td class="px-4 py-2"><?php echo e(optional($otp->expires_at)->format('Y-m-d H:i:s')); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="px-4 py-6 text-center text-slate-500">No OTP records found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="border-t border-slate-200 px-4 py-3"><?php echo e($otps->links()); ?></div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\frontdesk\otps\index.blade.php ENDPATH**/ ?>