<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Patients Print</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { width: 100%; border-collapse: collapse; font-size: 12px; }
        th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
        th { background: #f4f4f4; }
    </style>
</head>
<body onload="window.print()">
    <h3>Patients List</h3>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Lab</th>
                <th>Email</th>
                <th>Phone</th>
                <th>DOB</th>
                <th>Gender</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($patient->id); ?></td>
                    <td><?php echo e($patient->full_name); ?></td>
                    <td><?php echo e(optional($patient->lab)->name); ?> <?php echo e(optional($patient->lab)->branch_name); ?></td>
                    <td><?php echo e($patient->email); ?></td>
                    <td><?php echo e($patient->phone); ?></td>
                    <td><?php echo e(optional($patient->dob)->format('Y-m-d')); ?></td>
                    <td><?php echo e(ucfirst($patient->gender ?: '-')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH C:\wamp64\www\lab-result-portal\resources\views\frontdesk\patients\print.blade.php ENDPATH**/ ?>